package com.applovin.sdk;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * Created by santoshbagadi on 10/31/23.
 * <p>
 * This class encapsulates various data for CMP flow related errors.
 */
public interface AppLovinCmpError
{
    @RequiredArgsConstructor(access = AccessLevel.PRIVATE)
    enum Code
    {
        /**
         * Indicates that an unspecified error has occurred.
         */
        UNSPECIFIED( -1 ),

        /**
         * Indicates that the CMP has not been integrated correctly.
         */
        INTEGRATION_ERROR( 1 ),

        /**
         * Indicates that the CMP form is unavailable.
         */
        FORM_UNAVAILABLE( 2 ),

        /**
         * Indicates that the CMP form is not required.
         */
        FORM_NOT_REQUIRED( 3 );

        @Getter
        private final int value;
    }

    /**
     * The error code for this error.
     */
    Code getCode();

    /**
     * The error message for this error.
     */
    String getMessage();

    /**
     * The error code returned by the CMP.
     */
    int getCmpCode();

    /**
     * The error message returned by the CMP.
     */
    String getCmpMessage();
}
